<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Dtos\Notification;

use Erlage\Photogram\Data\Tables\Post\PostTable;
use Erlage\Photogram\Data\Tables\User\UserTable;
use Erlage\Photogram\Data\Dtos\Common\StringListDTO;
use Erlage\Photogram\Data\Dtos\Common\StringCollectionMapDTO;

final class NotificationLinkedContentDTO extends StringCollectionMapDTO
{
    /**
     * @var bool
     */
    private $isLinkedUserIds;

    /**
     * @var bool
     */
    private $isLinkedPostIds;

    public function containUserIds(): bool
    {
        if ( ! isset($this -> isLinkedUserIds))
        {
            $this -> isLinkedUserIds = $this -> containsKey(UserTable::getTableName());
        }

        return $this -> isLinkedUserIds;
    }

    public function containPostIds(): bool
    {
        if ( ! isset($this -> isLinkedPostIds))
        {
            $this -> isLinkedPostIds = $this -> containsKey(PostTable::getTableName());
        }

        return $this -> isLinkedPostIds;
    }

    public function getUserIds(): StringListDTO
    {
        return $this -> getValue(UserTable::getTableName());
    }

    public function getPostIds(): StringListDTO
    {
        return $this -> getValue(PostTable::getTableName());
    }

    public function linkUserId(string $userId)
    {
        if ( ! $this -> containUserIds())
        {
            $this -> add(UserTable::getTableName(), new StringListDTO());
        }

        $linkedUserIds = $this -> getValue(UserTable::getTableName());

        if ( ! $linkedUserIds -> containsValue($userId))
        {
            $linkedUserIds -> push($userId);
        }
    }

    public function linkPostId(string $postId)
    {
        if ( ! $this -> containPostIds())
        {
            $this -> add(PostTable::getTableName(), new StringListDTO());
        }

        $linkedpostIds = $this -> getValue(PostTable::getTableName());

        if ( ! $linkedpostIds -> containsValue($postId))
        {
            $linkedpostIds -> push($postId);
        }
    }
}
